#!/bin/bash
# -----------------------------------------------------------------------------
# Script to genereate Nginx load balance for FileMaker Server
# -----------------------------------------------------------------------------

export NODE_ENV=production
NGINXLB_BASE=$(dirname "$0")
echo "Starting NginxLB dir =" $NGINXLB_BASE
case "$(uname -s)" in
	Darwin)
		NGINXLB_NODEJS="$NGINXLB_BASE/nginxConfigCreator.js"
    NODE_PATH="/Library/FileMaker Server/node/bin/node"
		;;
	Linux)
	NODE_PATH="/opt/FileMaker/FileMaker Server/node/bin/node"
		NGINXLB_NODEJS="/opt/FileMaker/FileMaker Server/Tools/NginxLB/nginxConfigCreator.js"
esac

echo "Generating Nginx load balancer config for FileMaker Server"

echo "Execute node JS $NODE_PATH $NGINXLB_NODEJS"
NODE_ENV=production "$NODE_PATH" "$NGINXLB_NODEJS"

exit 0
